@extends('dashboard.body.main')

@section('container')

        <div class="col-lg-12">
            @if (session()->has('success'))
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Outstanding Payments for <i>{{$Supplier->name }} (TZS {{  number_format($header->Amount,2) }})</i></h4>
                    <!--
                    <p class="mb-0">A supplier dashboard lets you easily gather and visualize supplier data from optimizing <br>
                        the supplier experience, ensuring supplier retention. </p>
                    -->
                </div>
                <div>
                    <ul class="list-inline">
                        <li class="list-inline-item">
                            <form method="GET" action="{{route('payment.outgoing.index')}}">
                                @csrf
                            <button class = "btn" type="submit"><i class="fa-solid fa-plus mr-3"></i>Cancel</button>
                            <!-- <a href="{{ route('order.index') }}" class="btn btn-danger add-list"><i class="fa-solid fa-trash mr-3"></i>Clear Search</a> -->
                            </form>
                        </li>
                        <li class="list-inline-item">
                            <form method="POST" action="{{route('payment.outgoing.complete',[$header->id])}}">
                                @csrf
                            <button class = "btn" type="submit"><i class="fa-solid fa-plus mr-3"></i>Complete</button>
                            <!-- <a href="{{ route('order.index') }}" class="btn btn-danger add-list"><i class="fa-solid fa-trash mr-3"></i>Clear Search</a> -->
                            </form>
                        <li>
                    </ul>
                </div>
            </div>
        </div>

        <table class="table">
            <tr>
                <td>PO Number</td>
                <td>Amount (TZS)</td>
                <td>Amt Paid</td>
                <td>Action</td>
            </tr>
        @foreach($outstandingPays as $outstandingPay)
            @php  $detCtrlNum = is_null($outstandingPay->id)?'':$outstandingPay->id;  @endphp
            <tr>
                <td>{{$outstandingPay->ControlNum}}</td>
                <td>{{number_format($outstandingPay->ItemTotal)}}</td>
                <td>{{number_format($outstandingPay->amount)}}</td>

                <td>Status</td>
                <td>
                    <ul class="list-inline">
                        <li class="list-inline-item">
                            <form method="POST" action="{{ route('payment.outgoing.pay',[$header->id,$outstandingPay->ControlNum,$outstandingPay->ItemTotal ]) }}">
                                @csrf
                                <button type="submit" class="btn">Pay</button>
                            </form>
                        </li>
                        <li class="list-inline-item">
                            <form method="POST" action="{{ route('payment.outgoing.pay.delete',[$detCtrlNum]) }}">
                                @csrf
                                <button type="submit" class="btn">Del</button>
                            </form>
                        </li>
                    </ul>
                </td>
            </tr>
        @endforeach
        </table>


@endsection
