<?php $__env->startSection('container'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <?php if(session()->has('success')): ?>
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text"><?php echo e(session('success')); ?></div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            <?php endif; ?>
            <?php if(session()->has('error')): ?>
                <div class="alert text-white bg-danger" role="alert">
                    <div class="iq-alert-text"><?php echo e(session('success')); ?></div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            <?php endif; ?>
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Stores List</h4>

                </div>
                <div>
                    <!--
                    <a href="<?php echo e(route('products.importView')); ?>" class="btn btn-success add-list">Import</a>
                    <a href="<?php echo e(route('products.exportData')); ?>" class="btn btn-warning add-list">Export</a>
                    -->
                    <!-- <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary add-list">Add Product</a> -->
                    <form method="POST" action="<?php echo e(route('stores.create')); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('GET'); ?>
                        <button class="btn">Add Store</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="table-responsive rounded mb-3">
                <table class="table mb-0">
                    <thead class="bg-white text-uppercase">
                        <tr class="ligth ligth-data">
                            <th>Name</th>
                            <th>Code</th>
                            <th>Address</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="ligth-body">
                        <?php $__empty_1 = true; $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>

                            <td><?php echo e($store->address1); ?></td>
                            <td><?php echo e($store->name); ?></td>
                            <td><?php echo e($store->phone1); ?></td>
                            <td>
                                <ul class="list-inline">
                                    <li class="list-inline-item">
                                        <a class="btn" href="<?php echo e(route('store.price.index',$store->id)); ?>">store price</a>
                                    </li>
                                    <li class="list-inline-item">
                                        <form action="<?php echo e(route('stores.edit',$store->id)); ?>" method="POST" style="margin-bottom: 5px">
                                            <?php echo method_field('GET'); ?>
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn  mr-2 border-none"  data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit"><i class="fa-solid fa-box-open mr-0"></i>View</button>
                                        </form>
                                    </li>
                                </ul>
                            </td>
                        </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="alert text-white bg-danger" role="alert">
                            <div class="iq-alert-text">Data not Found.</div>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <i class="ri-close-line"></i>
                            </button>
                        </div>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($stores->links()); ?>

        </div>
    </div>
    <!-- Page end  -->
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.body.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/smaryqic/rories-apps.co.tz/n4/resources/views/stores/index.blade.php ENDPATH**/ ?>