<?php $__env->startSection('container'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <?php if(session()->has('success')): ?>
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text"><?php echo e(session('success')); ?></div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            <?php endif; ?>
            <?php if(session()->has('error')): ?>
                <div class="alert text-white bg-danger" role="alert">
                    <div class="iq-alert-text"><?php echo e(session('success')); ?></div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            <?php endif; ?>
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Product List</h4>

                </div>
                <div>
                    <a href="<?php echo e(route('products.importView')); ?>" class="btn btn-success add-list">Import</a>
                    <a href="<?php echo e(route('products.exportData')); ?>" class="btn btn-warning add-list">Export</a>
                    <!-- <a href="<?php echo e(route('products.create')); ?>" class="btn btn-primary add-list">Add Product</a> -->
                    <form method="POST" action="<?php echo e(route('product.bycategory.add',$SubcategoryId)); ?>">
                        <?php echo csrf_field(); ?>
                        <button class="btn">Add Product</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <form action="<?php echo e(route('products.index')); ?>" method="get">
                <div class="d-flex flex-wrap align-items-center justify-content-between">
                    <div class="form-group row">
                        <label for="row" class="col-sm-3 align-self-center">Row:</label>
                        <div class="col-sm-9">
                            <select class="form-control" name="row">
                                <option value="10" <?php if(request('row') == '10'): ?>selected="selected"<?php endif; ?>>10</option>
                                <option value="25" <?php if(request('row') == '25'): ?>selected="selected"<?php endif; ?>>25</option>
                                <option value="50" <?php if(request('row') == '50'): ?>selected="selected"<?php endif; ?>>50</option>
                                <option value="100" <?php if(request('row') == '100'): ?>selected="selected"<?php endif; ?>>100</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="control-label col-sm-3 align-self-center" for="search">Search:</label>
                        <div class="input-group col-sm-8">
                            <input type="text" id="search" class="form-control" name="search" placeholder="Search product" value="<?php echo e(request('search')); ?>">
                            <div class="input-group-append">
                                <button type="submit" class="input-group-text bg-primary"><i class="fa-solid fa-magnifying-glass font-size-20"></i></button>
                                <a href="<?php echo e(route('products.index')); ?>" class="input-group-text bg-danger"><i class="fa-solid fa-trash"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <div class="col-lg-12">
            <div class="table-responsive rounded mb-3">
                <table class="table mb-0">
                    <thead class="bg-white text-uppercase">
                        <tr class="ligth ligth-data">
                            <th>No.</th>
                            <!-- <th>Photo</th> -->
                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('product_name', 'name'));?></th>
                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('category.name', 'category'));?></th>
                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('supplier.name', 'supplier'));?></th>
                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('selling_price', 'selling price'));?></th>
                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('buying_price', 'buying price'));?></th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="ligth-body">
                        <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>



                        <tr>
                            <td><?php echo e((($products->currentPage() * 10) - 10) + $loop->iteration); ?></td>
                            <!--
                            <td>
                                <img class="avatar-60 rounded" src="<?php echo e($product->product_image ? asset('storage/products/'.$product->product_image) : asset('assets/images/product/default.webp')); ?>">
                            </td>
                            -->
                            <td><?php echo e($product->product_name); ?></td>
                            <td><?php echo e($product->category_name); ?></td>
                            <td><?php echo e($product->suppliers_name); ?></td>
                            <td><?php echo e($product->selling_price); ?></td>
                            <td><?php echo e($product->buying_price); ?></td>
                            <td>
                                <?php if($product->expire_date > Carbon\Carbon::now()->format('Y-m-d')): ?>
                                    <span class="badge rounded-pill bg-success">Valid</span>
                                <?php else: ?>
                                    <span class="badge rounded-pill bg-danger">Invalid</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <form action="" method="POST" style="margin-bottom: 5px">
                                    <?php echo method_field('delete'); ?>
                                    <?php echo csrf_field(); ?>
                                    <div class="d-flex align-items-center list-action">
                                        <a class="btn  mr-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="barcode" href="<?php echo e(route('product.item.barcode',$product->id)); ?>"><i class="ri-barcode-line mr-0"></i>
                                        </a>
                                        <a class="btn  mr-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="View"
                                            href=""><i class="ri-eye-line mr-0"></i>
                                        </a>
                                        <a class="btn  mr-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit"
                                            href=""><i class="ri-pencil-line mr-0"></i>
                                        </a>


                                        <form  action="<?php echo e(route('products.destroy',$product->id )); ?>" method="POST" style="display: none;">
                                             <?php echo csrf_field(); ?>
                                             <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn  mr-2 border-none" onclick="return confirm('Are you sure you want to delete this record?')" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete"><i class="ri-delete-bin-line mr-0"></i></button>
                                        </form>


                                    </div>
                                </form>
                            </td>
                        </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="alert text-white bg-danger" role="alert">
                            <div class="iq-alert-text">Data not Found.</div>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <i class="ri-close-line"></i>
                            </button>
                        </div>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($products->links()); ?>

        </div>
    </div>
    <!-- Page end  -->
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.body.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rories/Downloads/laravel-point-of-sale-main/resources/views/products/index.blade.php ENDPATH**/ ?>