<?php $__env->startSection('container'); ?>
<div class="container-fluid">

    <div class="row">
        <div class="col-lg-12">
            <?php if(session()->has('success')): ?>
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text"><?php echo e(session('success')); ?></div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            <?php endif; ?>
            <div>
                <h4 class="mb-3">Point of Sale</h4>
            </div>
        </div>

        <div class="col-lg-6 col-md-12 mb-3">
            <table class="table">
                <thead>
                    <tr class="ligth">
                        <th scope="col">Name</th>
                        <th scope="col">QTY</th>
                        <th scope="col">Price</th>
                        <th scope="col">SubTotal</th>
                        <th scope="col">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $productItem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($item->name); ?></td>
                        <td style="min-width: 140px;">
                            <form action="<?php echo e(route('pos.updateCart', $item->rowId)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="input-group">
                                    <input type="number" class="form-control" name="qty" required value="<?php echo e(old('qty', $item->qty)); ?>">
                                    <div class="input-group-append">
                                        <button type="submit" class="btn btn-success border-none" data-toggle="tooltip" data-placement="top" title="" data-original-title="Sumbit"><i class="fas fa-check"></i></button>
                                    </div>
                                </div>
                            </form>
                        </td>
                        <td><?php echo e($item->price); ?></td>
                        <td><?php echo e($item->subtotal); ?></td>
                        <td>
                            <a href="<?php echo e(route('pos.deleteCart', $item->rowId)); ?>" class="btn btn-danger border-none" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete"><i class="fa-solid fa-trash mr-0"></i></a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="container row text-center">
                <div class="form-group col-sm-6">
                    <p class="h4 text-primary">Quantity: <?php echo e(Cart::count()); ?></p>
                </div>
                <div class="form-group col-sm-6">
                    <p class="h4 text-primary">Subtotal: <?php echo e(Cart::subtotal()); ?></p>
                </div>
                <div class="form-group col-sm-6">
                    <p class="h4 text-primary">Vat: <?php echo e(Cart::tax()); ?></p>
                </div>
                <div class="form-group col-sm-6">
                    <p class="h4 text-primary">Total: <?php echo e(Cart::total()); ?></p>
                </div>
            </div>

            <form action="<?php echo e(route('pos.createInvoice')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row mt-3">
                    <div class="col-md-12">
                        <div class="input-group">
                            <select class="form-control" id="customer_id" name="customer_id">
                                <option selected="" disabled="">-- Select Customer --</option>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($customer->id); ?>"><?php echo e($customer->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php $__errorArgs = ['customer_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback">
                            <?php echo e($message); ?>

                        </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-12 mt-4">
                        <div class="d-flex flex-wrap align-items-center justify-content-center">
                            <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-primary add-list mx-1">Add Customer</a>
                            <button type="submit" class="btn btn-success add-list mx-1">Create Invoice</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <div class="col-lg-6 col-md-12">
            <div class="card card-block card-stretch card-height">
                <div class="card-body">
                    <form action="#" method="get">
                        <div class="d-flex flex-wrap align-items-center justify-content-between">
                            <div class="form-group row">
                                <label for="row" class="align-self-center mx-2">Row:</label>
                                <div>
                                    <select class="form-control" name="row">
                                        <option value="10" <?php if(request('row') == '10'): ?>selected="selected"<?php endif; ?>>10</option>
                                        <option value="25" <?php if(request('row') == '25'): ?>selected="selected"<?php endif; ?>>25</option>
                                        <option value="50" <?php if(request('row') == '50'): ?>selected="selected"<?php endif; ?>>50</option>
                                        <option value="100" <?php if(request('row') == '100'): ?>selected="selected"<?php endif; ?>>100</option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="control-label col-sm-3 align-self-center" for="search">Search:</label>
                                <div class="input-group col-sm-8">
                                    <input type="text" id="search" class="form-control" name="search" placeholder="Search product" value="<?php echo e(request('search')); ?>">
                                    <div class="input-group-append">
                                        <button type="submit" class="input-group-text bg-primary"><i class="fa-solid fa-magnifying-glass font-size-20"></i></button>
                                        <a href="<?php echo e(route('products.index')); ?>" class="input-group-text bg-danger"><i class="fa-solid fa-trash"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>


                    <div class="table-responsive rounded mb-3 border-none">
                        <table class="table mb-0">
                            <thead class="bg-white text-uppercase">
                                <tr class="ligth ligth-data">
                                    <th>No.</th>
                                    <th>Photo</th>
                                    <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('product_name', 'name'));?></th>
                                    <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('selling_price', 'price'));?></th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody class="ligth-body">
                                <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e((($products->currentPage() * 10) - 10) + $loop->iteration); ?></td>
                                    <td>
                                        <img class="avatar-60 rounded" src="<?php echo e($product->product_image ? asset('storage/products/'.$product->product_image) : asset('assets/images/product/default.webp')); ?>">
                                    </td>
                                    <td><?php echo e($product->product_name); ?></td>
                                    <td><?php echo e($product->selling_price); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('pos.addCart')); ?>" method="POST"  style="margin-bottom: 5px">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="id" value="<?php echo e($product->id); ?>">
                                            <input type="hidden" name="name" value="<?php echo e($product->product_name); ?>">
                                            <input type="hidden" name="price" value="<?php echo e($product->selling_price); ?>">

                                            <button type="submit" class="btn btn-primary border-none" data-toggle="tooltip" data-placement="top" title="" data-original-title="Add"><i class="far fa-plus mr-0"></i></button>
                                        </form>
                                    </td>
                                </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="alert text-white bg-danger" role="alert">
                                    <div class="iq-alert-text">Data not Found.</div>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <i class="ri-close-line"></i>
                                    </button>
                                </div>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo e($products->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.body.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rories/Downloads/laravel-point-of-sale-main/resources/views/pos/index.blade.php ENDPATH**/ ?>