<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Http\Controllers\Home;
use App\Http\Controllers\TaxController;
use App\Http\Controllers\new\CategoryController;
use App\Http\Controllers\new\UnitController;
use App\Http\Controllers\new\SupplierController;
use App\Http\Controllers\new\CustomerController;
use App\Http\Controllers\new\ProductController;
use App\Http\Controllers\new\InvoiceController;
use App\Http\Controllers\new\SalesController;
use App\Http\Controllers\new\PurchaseController;






Route::get('/', 'HomeController@index')->name('home');
Route::get('/home', 'HomeController@index')->name('home');
Route::get('/edit_profile', 'HomeController@edit_profile')->name('edit_profile');
Route::POST('/update_profile/{id}', 'HomeController@update_profile')->name('update_profile');
Route::get('/password_change/', 'HomeController@update_password')->name('update_password');

Route::resource('tax', TaxController::class);
Route::resource('category', CategoryController::class);
Route::resource('unit', UnitController::class);
Route::resource('supplier', SupplierController::class);
Route::resource('customer', CustomerController::class);
Route::resource('product', ProductController::class);
Route::resource('invoice', InvoiceController::class);
Route::get('/sales', [SalesController::class, 'index'])->name('sales.index');
Route::resource('purchase', PurchaseController::class);
Route::get('/findPrice', [InvoiceController::class,'findPrice'])->name('findPrice');
Route::get('/findPricePurchase', [PurchaseController::class,'findPricePurchase'])->name('findPricePurchase');




