<?php

use App\Http\Controllers\Reports\repPurchases;

use App\Http\Controllers\Reports\repStockLevelVal;

use App\Http\Controllers\Reports\repStockLevelSelling;


Route::middleware('auth','permission:report.menu')->group(function(){


    Route::resource('repPurchases',repPurchases::class);
    
    Route::resource('ProductList',App\Http\Controllers\Reports\repProductList::class);
    Route::POST('ProductList',[App\Http\Controllers\Reports\repProductList::class,'Report'])->name('ProductList.Report');
    Route::GET('ProductList/pdf',[App\Http\Controllers\Reports\repProductList::class,'pdf'])->name('ProductList.pdf');
    
    
    Route::resource('StockLevel',App\Http\Controllers\Reports\repStockLevelVal::class);
    Route::POST('StockLevel',[App\Http\Controllers\Reports\repStockLevelVal::class,'Report'])->name('StockLevel.Report');
    
    
    Route::resource('StockSalesLevel',App\Http\Controllers\Reports\repStockLevelSelling::class);
    Route::POST('StockSalesLevel',[App\Http\Controllers\Reports\repStockLevelSelling::class,'Report'])->name('StockSalesLevel.Report');
    
    
    
    
    Route::GET('index',[App\Http\Controllers\Reports\Stocklevels::class,'index'])->name('Stocklevels.index');
    Route::GET('pdf',[App\Http\Controllers\Reports\Stocklevels::class,'pdf'])->name('Stocklevels.pdf');
    
    
    
    Route::GET('store/index',[App\Http\Controllers\Reports\Stocklevels::class,'storeindex'])->name('Stocklevels.Store.index');
    Route::POST('store/report',[App\Http\Controllers\Reports\Stocklevels::class,'LoadReport'])->name('Stocklevels.Store.report');
    Route::GET('store/pdf',[App\Http\Controllers\Reports\Stocklevels::class,'storepdf'])->name('Stocklevels.Store.pdf');
    
    
    
    
    Route::GET('outstanding/index',[App\Http\Controllers\Reports\outstandings::class,'index'])->name('outstanding.index');
    Route::GET('outstanding/pdf',[App\Http\Controllers\Reports\outstandings::class,'pdf'])->name('outstanding.pdf');
    
    
    Route::GET('profitandloss/index',[App\Http\Controllers\Reports\profitandLoss::class,'index'])->name('profitandloss.index');
    Route::POST('profitandloss/index',[App\Http\Controllers\Reports\profitandLoss::class,'report'])->name('profitandloss.report');
    Route::GET('profitandloss/pdf',[App\Http\Controllers\Reports\profitandLoss::class,'pdf'])->name('profitandloss.pdf');
    
    
    Route::GET('dailysales/index',[App\Http\Controllers\Reports\dailysales::class,'index'])->name('dailysales.index');
    Route::POST('dailysales/index',[App\Http\Controllers\Reports\dailysales::class,'report'])->name('dailysales.report');
    Route::POST('dailysales/detail/{store}/{StartDate}/{EndDate}/',[App\Http\Controllers\Reports\dailysales::class,'store_daily_report'])->name('dailysales.detailed.report');
    
    
    Route::GET('poreceives/index',[App\Http\Controllers\Reports\poReceives::class,'index'])->name('poreceives.index');
    Route::POST('poreceives/report',[App\Http\Controllers\Reports\poReceives::class,'report'])->name('poreceives.report');

});