@extends('dashboard.body.main')

@section('container')
<div class="container-fluid">

        <div class="col-lg-12">
            @if (session()->has('success'))
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Item Unit List</h4>

                </div>
                <div>
                    <a href="{{ route('itemunit.create') }}" class="btn btn add-list"><i class="fa-solid fa-plus mr-3"></i>Add Item Unit</a>
                    <a href="{{ route('order.index') }}" class="btn add-list"><i class="fa-solid fa-trash mr-3"></i>Clear Search</a>
                </div>
            </div>
        </div>



    <div class="row">


                    <table class="table table-hover table-bordered" id="sampleTable">
                            <thead>
                            <tr>
                                <th>Code </th>
                                <th>Description</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach( $units as $unit)
                            <tr>
                                <td>{{ $unit->Code }} </td>
                                <td>{{ $unit->Description }} </td>
                                @if($unit->status)
                                <td>Active</td>
                                    @else
                                    <td>Inactive</td>
                                @endif


                                <td>
                                    <a class="btn btn-primary btn-sm" href="{{route('itemunit.edit', $unit->id)}}"><i class="fa fa-edit" ></i></a>
                                    <button class="btn btn-danger btn-sm waves-effect" type="submit" onclick="deleteTag({{ $unit->id }})">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                    <form id="delete-form-{{ $unit->id }}" action="{{ route('itemunit.destroy',$unit->id) }}" method="POST" style="display: none;">
                                        @csrf
                                        @method('DELETE')
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                            </tbody>
                        </table>




    </div>
    <!-- Page end  -->
</div>

@endsection





















