@extends('dashboard.body.main')

@section('container')


<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            @if (session()->has('success'))
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert text-white bg-danger" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif


 <form method="POST" action="{{route('stores.store')}}">
        @csrf


            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Stores Create</h4>

                </div>
                <div>
                    <!--
                    <a href="{{ route('products.importView') }}" class="btn btn-success add-list">Import</a>
                    <a href="{{ route('products.exportData') }}" class="btn btn-warning add-list">Export</a>
                    -->
                    <!-- <a href="{{ route('products.create') }}" class="btn btn-primary add-list">Add Product</a> -->

                        <button type="submit" class="btn">Save</button>

                        <a class="btn" href="{{route('stores.index')}}">cancel</a>

                </div>
            </div>
        </div>

        <div class="col-lg-12">
                        <div class="row">
                            <div class="form-group col-md-8">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="name"  name="name" placeholder="Stores Name" required/>
                                    <label for="name">Stores Name<span class="text-danger">*</span></label>
                                </div>
                                @error('name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="form-group col-md-4">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="address1"  name="address1" placeholder="Code" required/>
                                    <label for="address1">Code<span class="text-danger">*</span></label>
                                </div>
                                @error('address1')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>


                        <div class="row">
                            <div class="form-group col-md-5">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="address2"  name="address2" placeholder="Location" required/>
                                    <label for="address2">Region<span class="text-danger">*</span></label>
                                </div>
                                @error('address2')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="form-group col-md-5">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="address3"  name="address3" placeholder="Location" required/>
                                    <label for="address3">District<span class="text-danger">*</span></label>
                                </div>
                                @error('address3')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>





                        <div class="row">
                            <div class="form-group col-md-4">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="phone1"  name="phone1" placeholder="Location" />
                                    <label for="phone1">Address</label>
                                </div>
                                @error('phone1')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="form-group col-md-4">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="phone2"  name="phone2" placeholder="Location" />
                                    <label for="phone2">Phone</label>
                                </div>
                                @error('phone2')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
                </form>

        </div>
    </div>
    <!-- Page end  -->
</div>

@endsection
