@extends('dashboard.body.main')

@section('container')
    <div class="container-fluid">
        <div class="row">







            <div class="col-1">&nbsp;</div>
            <div class="col-5">

                    <div class="row" id="searchItems">
                            <div class="input-group mb-3">
                                <input type="text" id="searchValue" name="searchValue" class="form-control" placeholder="Scan bar code" aria-label="Scan bar code" aria-describedby="basic-addon2">
                                <div class="input-group-append">
                                  <ul>
                                       <li>
                                  <div class="form-check">
                                          <input type="radio" class="form-check-input" id="mode" name="mode" value="1" checked onChange="modechange(1)">Barcode
                                          <label class="form-check-label" for="radio1"></label>
                                  </div>
                                        </li>
                                        <li>
                                  <div class="form-check">
                                          <input type="radio" class="form-check-input" id="mode" name="mode" value="2" onChange="modechange(2)">Description
                                          <label class="form-check-label" for="radio2"></label>
                                  </div>
                                        </li>
                                    </ul>
                                </div>

                            </div>
                    </div>


                    <div class="row" id="searchresult">

                    </div>
                    <div class="row" id="EntryForm">

                            <form action="{{ route('sales.item.save') }}" method="POST" enctype="multipart/form-data" id="SalesItem">
                                @csrf
                                <div class="form-floating mb-3">
                                  <input type="text" class="form-control" id="itemname"  name="itemname" placeholder="Item name">

                                  <label for="floatingInput">Item name</label>
                                </div>
                                <div class="form-floating mb-3">
                                  <input type="text" class="form-control" id="price"  name="price" placeholder="Item Price">
                                  <label for="floatingPassword">Item Price</label>
                                </div>
                                <div class="form-floating mb-3">
                                  <input type="text" class="form-control" id="taxname"  name="taxname" placeholder="Tax">
                                  <label for="floatingPassword">Tax</label>
                                </div>
                                <div class="form-floating mb-3">
                                  <input type="text" class="form-control" id="quantity"  name="quantity" placeholder="Quantity">
                                  <label for="floatingPassword">Quantity</label>
                                </div>


                                <div class="form-floating mb-3">
                                    <button type="submit" class="btn btn-secondary" name="btnSave" id="btnSavexx">Submit</button>
                                </div>


                                  <input type="text" class="form-control" id="taxctrlnum"  name="taxctrlnum" placeholder="Tax">
                                  <input type="text" class="form-control" id="itemctrlnum"  name="itemctrlnum" placeholder="Item name">

                                  <input type="text" class="form-control" id="OrderCtrlNum"  name="OrderCtrlNum" value="{{$ControlNum}}" />
                            </form>
                    </div>


            </div>
        </div>
    </div>




<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Mini Calculator</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Recipient:</label>
            <input type="text" class="form-control" id="CapturedAmount">
          </div>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Recipient:</label>
            <input type="text" class="form-control" id="BalanceAmount" readonly/>
          </div>
        </form>
      </div>

    </div>
  </div>
</div>








@endsection


@section('specificpagescripts');

<script>
    $(function() {
        document.getElementById('searchresult').innerHTML = "";
        $('#searchresult').hide();
    });


    modechange = function(varStatus){
        $('#searchValue').val("");
        if(varStatus==1){
            $('#searchValue').attr('placeholder','Scan BarCode');
            $('#searchresult').hide();
            $('#EntryForm').show();
        } else {
            $('#searchValue').attr('placeholder','Enter Item Description');
            $('#searchresult').show();
            $('#EntryForm').hide();
            getItemslists();
        }
    }

    $('#searchValue').keyup(
        function(){
                    //gettig selected mode
               if($("input[name=mode]:checked").val() == 1){
                    ItemDetailsByBarCode($('#searchValue').val());
               } else {
                    ItemDetailsByDescription($('#searchValue').val());
               }
        }
    );



        var varDefaault = "xxx";
        var itemTotal = $("#quantity").val() * $("#price").val();
        $('#boughtItems').append(varDefaault.concat('<tr><td>',$("#itemname").val(),'</td> <td>',$("#quantity").val(),'</td>,<td>',$("#price").val(),'</td><td>', itemTotal ,'</td></tr>'));

        computeItemTotal();
        NetTotal();
        //clearEntries();
    });

    computeItemTotal = function(){
        valItemTotal = 0;
        $('#boughtItems tr').each(function(){
            var valQuantity = $(this).closest("tr").find('td:eq(1)').text();
            var valPrice = $(this).closest("tr").find('td:eq(2)').text();
            valItemTotal = valItemTotal + valQuantity * valPrice;
           // $(this).closest("tr").find('td:eq(2)').text(valItemTotal);

            //$(this).find('td').each(function(){
                //alert(valItemTotal);

                //do your stuff, you can use $(this) to get current cell
            //})
        })
        $('#gross').val(valItemTotal);
    }



    ItemDetailsByBarCode = function(varBarCode){
            var url = "{{ route('sales.item', ":varBarCode") }}";
            url = url.replace(':varBarCode', varBarCode);
            $.ajax({
                type: 'GET',
                url: url,
                //data: formData,
                dataType: 'json',
                success: function(response) {
                    //alert(response.product_name);
                    setItemetails(response);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        $("#btnSave").focus();
    }



    ItemDetailsByDescription = function(varBarCode){

            var url = "{{ route('sales.item.description', ":varBarCode") }}";
            url = url.replace(':varBarCode', varBarCode);
            $.ajax({
                type: 'GET',
                url: url,
                //data: formData,
                dataType: 'json',
                success: function(response) {
                    console.log(response);
                    //  setItemetails(response);
                    //$('#ItemListsTable').append(varDefaault.concat('<tr><td>xxxxxx</td> <td>xxxxxx</td>,<td>xxxxxx</td><td>xxxxxxx</td></tr>'));
                    $('#ItemListsTable').append('<tr><td>xxxxxx</td> <td>xxxxxx</td>,<td>xxxxxx</td><td>xxxxxxx</td></tr>');
                     $('#ItemListsTable').append(response);

                },
                error: function(error) {
                    console.log(error);
                }
            });
        $("#btnSave").focus();
    }








    setItemetails = function(result){
        $("#itemname").val(result.product_name);
        $("#price").val(result.selling_price);


        //$("#taxname").val(result.tax_id);
        $("#quantity").val("1");
        //$("#taxctrlnum").val(result.tax_id);
        $("#itemctrlnum").val(result.id);
    }

    getItemslists = function(Items){
       $('#searchresult').html('<table class="table" id="ItemListsTable"><tr><th>Product</th><th>Quantity</th><th>Price</th><th>Total</th></tr></table>');
    }




    NetTotal = function(){
        alert($('#tax').val() + $('#tax').val());
        let vatTotal = parseInt($('#gross').val()) + parseInt($('#tax').val()) - parseInt($('#discount').val());
        $('#grandtotal').val(vatTotal);
    }

    $('#discount').change(function(){
        NetTotal();
    });
    clearEntries = function(){
        $("#itemname").val();
        $("#price").val();
        $("#taxname").val();
        $("#quantity").val();
        $("#taxctrlnum").val();
        $("#itemctrlnum").val();
    }



    $("#quantity").focusout(
        function(){
            $("#btnSave").focus();
        }
    );

    $('#amtPaid').keyup(function(){
        if($('#amtPaid').val() >= $('#grandtotal').val()){
            varBalance = $('#amtPaid').val() - $('#grandtotal').val()
            $('#balance').val(varBalance)
        }
    });











$('#exampleModal').on('show.bs.modal', function (event) {
  var button = $(event.relatedTarget) // Button that triggered the modal
  var recipient = button.data('whatever') // Extract info from data-* attributes
  // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
  // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
  var modal = $(this)
  modal.find('.modal-title').text('Mini Calculator ')

  $("#CapturedAmount").val("0");

  modal.find('.modal-body input').val(recipient)
})




$('#CapturedAmount').focusout(function(){

    let varBalance = $("#CapturedAmount").val() - $("#grandtotal").val();
    $("#BalanceAmount").val(varBalance);
});




</script>




@endsection
