@extends('dashboard.body.main')

@section('container')
    <div class="container-fluid">
        <div class="row">






            <div class="col-6">

                <div class="row mb-1">

                    <div class="col-4">
                            <button type="submit" class="col-12 btn-default btn-block p-3"  data-toggle="modal" data-target="#exampleModal" data-whatever="0">Calculator</button>
                    </div>


                    <div class="col-4">
                        <form method="POST" action="{{route('sales.item.complete',$ControlNum)}}">
                            @csrf
                            <button type="submit" class="col-12 btn-default btn-block p-3">Complete</button>
                        </form>
                    </div>

                    <div class="col-4">
                        <form method="GET" action="{{route('sales.index')}}">
                            <button type="submit" class="col-12 btn-default btn-block p-3">Cancel</button>
                        </form>
                    </div>

                </div>


                <div class="row">
                        <div class="mb-1 row">
                                <div class="col-6 row">
                                    <span class="col-6">Gross Total  </span>
                                    <input type="text" class="col-6 text-end" id="gross" value="0.00" readonly/>
                                 </div>
                                <div class="col-6 row" style="bgcolor:blue">
                                    <span class="col-6">Tax </span>
                                    <input type="text" class="col-6 text-end" id="tax" name="tax" value="0.00" readonly/>
                                </div>
                        </div>
                        <div class="mb-1 row">
                                <div class="col-6 row">
                                    <span class="col-6">Discount </span>
                                    <input type="text" class="col-6 text-end"  id="discount" name="discount" value="0.00">
                                </div>
                                <div class="col-6 row">
                                    <span class="col-6">Total </span>
                                    <input type="text" class="col-6 text-end" id="grandtotal" value="0.00" readonly/>
                                 </div>

                        </div>
                    <!--
                        <div class="mb-1 row">
                                 <div class="col-6 row">
                                    <span class="col-6">Amt Paid </span>
                                    <input type="text" class="col-6 text-end" id="amtPaid" name="amtPaid" value="0">
                                </div>
                                <div class="col-6 row">
                                    <span class="col-6">Balance </span>
                                    <input type="text"  class="col-6 text-end" id="balance"  name="balance" value="0.00" readonly/>
                                </div>
                        </div>
                    -->
                </div>





                <div class="row">
                    <table class="table" id="boughtItems">
                        <tr>
                            <th>Product</th>
                            <th>Quantity</th>
                            <th>Price</th>
                            <th>Total</th>
                            <th>Action</th>
                        </tr>
                    </table>
                </div>
             </div>


            <div class="col-1">&nbsp;</div>
            <div class="col-5">

                    <div class="row" id="searchItems">
                            <div class="input-group mb-3">
                                <input type="text" id="searchValue" name="searchValue" class="form-control" placeholder="Scan bar code" aria-label="Scan bar code" aria-describedby="basic-addon2">
                                <div class="input-group-append">
                                  <ul>
                                       <li>
                                  <div class="form-check">
                                          <input type="radio" class="form-check-input" id="mode" name="mode" value="1" checked onChange="modechange(1)">Barcode
                                          <label class="form-check-label" for="radio1"></label>
                                  </div>
                                        </li>
                                        <li>
                                  <div class="form-check">
                                          <input type="radio" class="form-check-input" id="mode" name="mode" value="2" onChange="modechange(2)">Description
                                          <label class="form-check-label" for="radio2"></label>
                                  </div>
                                        </li>
                                    </ul>
                                </div>

                            </div>
                    </div>


                    <div class="row" id="searchresult">

                    </div>
                    <div class="row" id="EntryForm">

                            <form data-action="{{ route('sales.item.save',$ControlNum) }}" method="POST" enctype="multipart/form-data" id="SalesItem">
                                @csrf
                                <div class="form-floating mb-3">
                                  <input type="text" class="form-control" id="itemname"  name="itemname" placeholder="Item name">

                                  <label for="floatingInput">Item name</label>
                                </div>
                                <div class="form-floating mb-3">
                                  <input type="text" class="form-control" id="price"  name="price" placeholder="Item Price">
                                  <label for="floatingPassword">Item Price</label>
                                </div>
                                <div class="form-floating mb-3">
                                  <input type="text" class="form-control" id="taxname"  name="taxname" placeholder="Tax">
                                  <label for="floatingPassword">Tax</label>
                                </div>
                                <div class="form-floating mb-3">
                                  <input type="text" class="form-control" id="quantity"  name="quantity" placeholder="Quantity">
                                  <label for="floatingPassword">Quantity</label>
                                </div>


                                <div class="form-floating mb-3">
                                    <button type="submit" class="btn btn-secondary" name="btnSave" id="btnSave">Save</button>
                                </div>


                                  <input type="hidden" class="form-control" id="taxctrlnum"  name="taxctrlnum" placeholder="Tax">
                                  <input type="hidden" class="form-control" id="itemctrlnum"  name="itemctrlnum" placeholder="Item name">

                                  <input type="hidden" class="form-control" id="OrderCtrlNum"  name="OrderCtrlNum" value="{{$ControlNum}}" />
                            </form>
                    </div>


            </div>
        </div>
    </div>




<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Mini Calculator</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Amount Paid:</label>
            <input type="text" class="form-control" id="CapturedAmount">
          </div>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Balance:</label>
            <input type="text" class="form-control" id="BalanceAmount" readonly/>
          </div>
        </form>
      </div>

    </div>
  </div>
</div>








@endsection


@section('specificpagescripts');

<script>
    $(function() {
        document.getElementById('searchresult').innerHTML = "";
        $('#searchresult').hide();
    });


    modechange = function(varStatus){
        $('#searchValue').val("");
        if(varStatus==1){
            $('#searchValue').attr('placeholder','Scan BarCode');
            $('#searchresult').hide();
            $('#EntryForm').show();
        } else {
            $('#searchValue').attr('placeholder','Enter Item Description');
            $('#searchresult').show();
            $('#EntryForm').hide();
            getItemslists();
        }
    }

    $('#searchValue').focusout(
        function(){
                    //gettig selected mode
               if($("input[name=mode]:checked").val() == 1){
                    ItemDetailsByBarCode($('#searchValue').val());
               } else {
                    ItemDetailsByDescription($('#searchValue').val());
               }
        }
    );


    $("#btnSave").click(function(){
        event.preventDefault();
        var url = "{{ route('sales.item.save', ":varOrderCtrlNum") }}";
        url = url.replace(':varOrderCtrlNum', $("#OrderCtrlNum").val());
        url = url.replace('?','/');
        $.ajax({
            type:'POST',
            url: url,
            data: $('#SalesItem').serialize(),
            success: function(response) {
                    //alert(response.product_name);
                    //setItemetails(response);

                  ItemBoughtList($("#OrderCtrlNum").val());

                },

            error: function(error) {
                    //alert(error.responseText);
                    console.log(error);
                }
        });
        clearEntries();
    });

    computeItemTotal = function(){
        valItemTotal = 0;
        $('#boughtItems tr').each(function(){
            var valQuantity = $(this).closest("tr").find('td:eq(1)').text();
            var valPrice = $(this).closest("tr").find('td:eq(2)').text();
            valItemTotal = valItemTotal + valQuantity * valPrice;
        })
        $('#gross').val(valItemTotal);
        NetTotal();
    }



    ItemDetailsByBarCode = function(varBarCode){
            var url = "{{ route('sales.item', ":varBarCode") }}";
            url = url.replace(':varBarCode', varBarCode);
            $.ajax({
                type: 'GET',
                url: url,
                //data: formData,
                dataType: 'json',
                success: function(response) {
                    //alert(response.text);
                    //alert(response.product_name);
                    setItemetails(response);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        $("#btnSave").focus();
    }




    ItemDetailsByBarCodeV2 = function(varBarCode){
            ItemDetailsByBarCode(varBarCode);
            $('#searchresult').hide();
            $('#EntryForm').show();
            $('#searchValue').val(varBarCode);


    }







    ItemDetailsByDescription = function(varBarCode){

            getItemslists();


            var url = "{{ route('sales.item.description', ":varBarCode") }}";
            url = url.replace(':varBarCode', varBarCode);



            $.ajax({
                type: 'GET',
                url: url,
                //data: formData,
                dataType: 'json',
                success: function(results) {

                    $('#ItemListsTable').html();
                     results.map(function(result){
                        console.log(result);
                        $('#ItemListsTable').append(`<tr><td>` + result.product_code + `</td><td><a href="#" onclick="ItemDetailsByBarCodeV2('` + result.barcode + `')"><i class="ri-gift-2-line wrapper-menu"></i></a></td></tr>`);
                     });


                },
                error: function(error) {
                    console.log(error);
                }
            });
        $("#btnSave").focus();
    }




    ItemBoughtList = function(ControlNum){
            //alert('Test');
            let varDefaault= "";
            var url = "{{ route('sales.item.boughtList', ":varBarCode") }}";
            url = url.replace(':varBarCode', ControlNum);
            //alert(url);
            $.ajax({
                type: 'GET',
                url: url,
                //data: formData,
                dataType: 'json',
                success: function(results) {
                    $('#boughtItems').html("");
                    results.map(function(result){
                        let varItemTotal = Number(result.price) * Number(result.quantity);
                        $('#boughtItems').append(varDefaault.concat(`<tr>
                                                                        <td>${result.product_name}</td>
                                                                        <td>${result.quantity}</td>
                                                                        <td>${result.price}</td>
                                                                        <td>${varItemTotal}</td>
                                                                        <td><form  enctype="multipart/form-data" id="ItemDel" >
                                                                            <button class"btn btn-primary" id="btnItemDel" name="btnItemDel" onclick="deleteItem('${ControlNum}','${result.itemctrlnum}')">Del</button>
                                                                            </form>
                                                                        </td>
                                                                    </tr>`));
                        computeItemTotal();
                        console.log(result.id);
                    });

                },
                error: function(error) {
                    //alert('Error');
                    console.log(error);
                }
            });
    }



    setItemetails = function(result){

        //alert("Test");
        $("#itemname").val(result.product_name);
        $("#price").val(result.selling_price);
        //$("#taxname").val(result.tax_id);
        $("#quantity").val("1");
        //$("#taxctrlnum").val(result.tax_id);
        $("#itemctrlnum").val(result.id);
        $("#taxctrlnum").val(result.tax_id);
        $("#taxname").val(result.name);
    }

    getItemslists = function(Items){
       $('#searchresult').html('<table class="table" id="ItemListsTable"><tr><th>Product</th><th>&nbsp;</th></tr></table>');
    }




    NetTotal = function(){
        //alert($('#tax').val() + $('#tax').val());
        let vatTotal = parseInt($('#gross').val()) + parseInt($('#tax').val()) - parseInt($('#discount').val());
        $('#grandtotal').val(vatTotal);
    }

    $('#discount').change(function(){
        NetTotal();
    });
    clearEntries = function(){
        $("#itemname").val();
        $("#price").val();
        $("#taxname").val();
        $("#quantity").val();
        $("#taxctrlnum").val();
        $("#itemctrlnum").val();
        $("#taxctrlnum").val();
        $("#taxname").val();
    }



    $("#quantity").focusout(
        function(){
            $("#btnSave").focus();
        }
    );

    $('#amtPaid').keyup(function(){
        if($('#amtPaid').val() >= $('#grandtotal').val()){
            varBalance = $('#amtPaid').val() - $('#grandtotal').val()
            $('#balance').val(varBalance)
        }
    });











$('#exampleModal').on('show.bs.modal', function (event) {
  var button = $(event.relatedTarget) // Button that triggered the modal
  var recipient = button.data('whatever') // Extract info from data-* attributes
  // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
  // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
  var modal = $(this)
  modal.find('.modal-title').text('Mini Calculator ')

  $("#CapturedAmount").val("0");

  modal.find('.modal-body input').val(recipient)
})




$('#CapturedAmount').focusout(function(){

    let varBalance = $("#CapturedAmount").val() - $("#grandtotal").val();
    $("#BalanceAmount").val(varBalance);
});

ItemDel = function(ControlNum,ItemId){
        event.preventDefault();
        var url = "{{route('sales.item.itemDelete',[':ControlNum',':ItemId'])}}";
        url = url.replace(':ControlNum', ControlNum);
        url = url.replace(':ItemId', ItemId);
        $.ajax({
            type: 'POST',
            url: url,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),},
            success:function(result){
                ItemBoughtList(ControlNum);
                console.log(result);
            },
            error:function(error){
                alert('Error');
                console.log(error);
            }
        });
    };



function deleteItem(ControlNum, ItemId) {
        if (!confirm('Are you sure you want to remove this item from the cart?')) {
            return;
        }

        //var url = "http://127.0.0.1:8001/Sales/itemDelete/" + ControlNum + "/" + ItemId;

        var url = "{{route('sales.item.itemDelete',[':ControlNum',':ItemId'])}}";
        url = url.replace(':ControlNum', ControlNum);
        url = url.replace(':ItemId', ItemId);


        $.ajax({
            type: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: url,
            success: function(response) {
                ItemBoughtList(ControlNum);
            },
            error: function(error) {
                console.error('Error deleting item:', error);
                alert('Error deleting item from cart');
            }
        });
    }
</script>




@endsection
