@extends('dashboard.body.main')

@section('container')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            @if (session()->has('success'))
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Purchase Order ({{ $orderNumber }})</h4>
                </div>
                <div>
                    <ul class="list-inline text-end">
                      <li class="list-inline-item"><a href="{{ route('order.supplier.items',$orderNumber) }}" class="btn btn add-list"><i class="fa-solid fa-plus mr-3"></i>Add Item</a></li>
                      <li class="list-inline-item">
                        <form method="POST" action="{{ route('order.items.cancel',$orderNumber) }}">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn">
                                <i class="fa-solid fa-trash mr-3"></i>Cancel
                            </button>
                        </form>
                      </li>
                      <li class="list-inline-item">
                            <form method="POST" action="{{route('purchase.order.complete',$orderNumber)}}">
                                    @csrf
                                    <button class="btn">Complete</button>
                            </form>
                      </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <!--
            <form action="{{ route('suppliers.index') }}" method="get">
                <div class="d-flex flex-wrap align-items-center justify-content-between">
                    <div class="form-group row">
                        <label for="row" class="col-sm-3 align-self-center">Row:</label>
                        <div class="col-sm-9">
                            <select class="form-control" name="row">
                                <option value="10" @if(request('row') == '10')selected="selected"@endif>10</option>
                                <option value="25" @if(request('row') == '25')selected="selected"@endif>25</option>
                                <option value="50" @if(request('row') == '50')selected="selected"@endif>50</option>
                                <option value="100" @if(request('row') == '100')selected="selected"@endif>100</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="control-label col-sm-3 align-self-center" for="search">Search:</label>
                        <div class="col-sm-8">
                            <div class="input-group">
                                <input type="text" id="search" class="form-control" name="search" placeholder="Search Order" value="{{ request('search') }}">
                                <div class="input-group-append">
                                    <button type="submit" class="input-group-text bg-primary"><i class="fa-solid fa-magnifying-glass font-size-20"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
            -->
        </div>
    </div>



    <div class="row">

                <div class="col-4">


                        <form class="form" method="POST" action="{{route('order.Supplier',$orderNumber)}}">
    
                            <div class="input-group mb-3">
                              <div class="input-group-prepend">
                                <label class="input-group-text" for="inputGroupSelect01"> Apply Date</label>
                              </div>
                              <input type="date" name="applyDate" id="applyDate" class="form-control" value="{{$applydate}}">
                            </div>
    
    
    
                            <div class="input-group mb-3">
                              <div class="input-group-prepend">
                                <label class="input-group-text" for="inputGroupSelect01"> Choose Currency</label>
                              </div>
                              <select class="custom-select" id="Currency" name="Currency">
                                <option value="1" selected>TZS</option>
                                <option value="2">USD</option>
                              </select>
                            </div>
    
    
    
    
    
                            <div class="input-group mb-3">
                                  
                                      @csrf
                                        <div class="input-group mb-3">
                                              <input type="text" class="form-control" id="supplier" name="supplier" placeholder="Select Supplier" value="{{$Supplier}}">
                                              <div class="input-group-append">
                                                    <button class="btn btn-outline-secondary" type="submit">Supplier</button>
                                              </div>
                                        </div>
                                  
                            </div>
                        </form>




                        <div class="form-floating mb-3 mt-3">
                          <input type="text" class="form-control" id="email" placeholder="Enter email" name="email" value="{{ number_format($POTotal) }}" style="text-align:right" />
                          <label for="email">Total Amount</label>
                        </div>

                        <div class="form-floating mt-3 mb-3">
                          <input type="text" class="form-control" id="pwd" placeholder="Enter password" name="pswd" value="{{ number_format($POTaxTotal) }}" style="text-align:right" />
                          <label for="pwd">Tax Amount</label>
                        </div>
                        <div class="form-floating mt-3 mb-3">
                          <input type="text" class="form-control" id="pwd" placeholder="Enter password" name="pswd" value="{{ number_format($POItemGrandTotal) }}" style="text-align:right" />
                          <label for="pwd">Grand Total</label>
                        </div>







                </div>
                <div class="col-8">
                                <div class="table-responsive rounded mb-3">
                                    <table class="table mb-0 col-12">
                                        <thead class="bg-white text-uppercase">
                                            <tr class="ligth ligth-data">
                                                <th>Product.</th>
                                                <!-- <th>Photo</th> -->
                                                <th>Quantity</th>
                                                <th>Price</th>
                                                <th>Item Total</th>
                                                <th>Tax</th>
                                                <th>Line Total</th>
                                                <th style="text-align:right" >Action</th>
                                            </tr>
                                        </thead>
                                        <tbody class="ligth-body">
                                                @foreach($POItemsLists as $POItemsList)
                                                    <tr class="ligth ligth-data">
                                                        <td>{{$POItemsList->product}}</td>
                                                        <!-- <td>{{$POItemsList->name}}</td> -->
                                                        <td style="text-align:right" >{{number_format($POItemsList->quantity,2)}}</td>
                                                        <td style="text-align:right" >{{number_format($POItemsList->ItemAmt,2)}}</td>
                                                        <td style="text-align:right" >{{number_format($POItemsList->ItemGrossTotal,2)}}</td>
                                                        <td style="text-align:right" >{{number_format($POItemsList->ItemTaxAmount,2)}}</td>
                                                        <td style="text-align:right" >{{number_format($POItemsList->ItemGrandTotal,2)}}</td>
                                                        <td style="text-align:right" >


                                                             <form action="{{ route('order.destroy',$POItemsList->id) }}" method="POST" >
                                                                 @csrf
                                                                 @method('DELETE')
                                                                 <button class="btn btn add-list" type="submit"><i class="ri-delete-bin-line "></i></button>

                                                             </form>

                                                        </td>
                                                    </tr>
                                                @endforeach
                                        </tbody>
                                    </table>
                                </div>
                    <!---     -->
                </div>

    </div>
    <!-- Page end  -->
</div>

@endsection
