@extends('dashboard.body.main')

@section('specificpagestyles')
    <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
    <script src="https://unpkg.com/gijgo@1.9.14/js/gijgo.min.js" type="text/javascript"></script>
    <link href="https://unpkg.com/gijgo@1.9.14/css/gijgo.min.css" rel="stylesheet" type="text/css" />
@endsection

@section('container')
<div class="container-fluid">
    <form action="{{ route('products.update.item',$product->id) }}" method="POST" enctype="multipart/form-data">

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <div class="header-title">
                        <h4 class="card-title">Add Product</h4>
                    </div>

                    <div>
                        <button type="submit" class="btn btn-primary mr-2">Update</button>
                        <a class="btn bg-danger" href="#">Delete</a>

                    </div>
                </div>

                <div class="card-body">
                    @csrf

                        <!-- begin: Input Data -->
                        <div class=" row align-items-center">
                            <div class="form-group col-6">
                                <label for="product_name">Product Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('product_name') is-invalid @enderror" id="product_name" name="product_name" value="{{ $product->product_code }}" required>
                                @error('product_name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            
                            <div class="form-group col-3">
                                <label for="category_id">Category <span class="text-danger">*</span></label>
                                <select class="form-control" name="category_id" id="category_id" required readonly />
                                    <option selected="" disabled>-- Select Category --</option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}" {{ $category->id == $SubcategoryId ? 'selected' : '' }}>{{ $category->name }}</option>
                                    @endforeach
                                </select>
                                @error('category_id')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>




                            <div class="form-group col-3">
                                <label for="supplier_id">Supplier <span class="text-danger">*</span></label>
                                <select class="form-control" name="supplier_id" required>
                                    <option selected="" disabled>-- Select Supplier --</option>
                                    @foreach ($suppliers as $supplier)
                                        <option value="{{ $supplier->id }}" {{ $supplier->id  == $product->supplier_id ? 'selected' : '' }} > {{ $supplier->name }}</option>
                                    @endforeach
                                </select>
                                @error('supplier_id')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>







                            <div class="form-group col-4">

                                <div class="form-floating mb-3 mt-3">
                                        <select class="form-select" id="BuyingUnit" name="BuyingUnit">
                                            <option></option>
                                            @foreach($units as $unit)
                                                <option value="{{$unit->id}}" {{ $unit->id  == $product->BuyingUnit ? 'selected' : '' }}>{{$unit->Code}}</option>
                                            @endforeach
                                        </select>
                                    <label for="sel1" class="form-label">Buying Unit</label>
                                </div>
                                @error('BuyingUnit')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>




                            <div class="form-group col-4">

                                <div class="form-floating mb-3 mt-3">
                                        <select class="form-select" id="SellingUnit" name="SellingUnit">

                                            <option></option>
                                            @foreach($units as $unit)
                                                <option value="{{$unit->id}}" {{ $unit->id  == $product->SellingUnit ? 'selected' : '' }}>{{$unit->Code}}</option>
                                            @endforeach

                                        </select>
                                    <label for="sel1" class="form-label">Selling Unit</label>
                                </div>
                                @error('BuyingUnit')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>





                            <div class="form-group col-4">
                                <div class="form-floating mb-3 ">
                                    <input type="text" id="factor" class="form-control" name="factor" placeholder="factor" value="{{ $product->factor  }}" required/>
                                    <label for="expire_date">Factor</label>
                                </div>
                                @error('expire_date')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>



<div class="form-group col-md-6">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="buying_price"  name="buying_price" placeholder="Item Price" value="{{ $product->buying_price }}" required/>
                                    <label for="buying_price">Buying Price per unit<span class="text-danger">*</span></label>
                                </div>
                                @error('buying_price')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>


                            <div class="form-group col-md-6">
                                 <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="selling_price" name="selling_price"  placeholder="selling Price"  value="{{ $product->selling_price }}" required>
                                    <label for="selling_price">Selling Price per unit<span class="text-danger">*</span></label>
                                 </div>
                                @error('selling_price')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>




                            <div class="form-group col-md-6">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="barcode" name="barcode" placeholder="barcode"  value="{{ $product->barcode }}" >
                                    <label for="product_garage">Product Barcode</label>
                                </div>
                                @error('product_garage')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>








                            <div class="form-group col-md-6">
                                <div class="form-floating mb-3 ">
                                    <select class="form-control" name="tax_id" required>
                                        <option selected="" disabled>-- Default Tax --</option>
                                        @foreach ($taxes as $tax)
                                            <option value="{{ $tax->id }}" {{ $tax->id  == $product->tax_id? 'selected' : '' }}>{{ $tax->name }}</option>
                                        @endforeach
                                    </select>

                                    <label for="supplier_id">Tax <span class="text-danger">*</span></label>
                                </div>
                                @error('supplier_id')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            
                            



                <div class="form-group col-md-4">
                            <div class="form-check">

                              <input class="form-check-input" type="checkbox" id="SalesStatus" name="SalesStatus" value="1" checked>
                              <label class="form-check-label">Item For Sale</label>
                            </div>

                    </div>


                    <div class="form-group col-md-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="Cauntable" name="Cauntable" value="1" checked>
                                <label class="form-check-label">Cauntable</label>
                            </div>

                        </div>


                        <div class="form-group col-md-4">
                            <div class="form-check">
                              <input class="form-check-input" type="checkbox" id="check1" name="option1" value="1" checked>
                              <label class="form-check-label">Option 1</label>
                            </div>

                        </div>










<!--






                            <div class="form-group col-md-6">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control @error('product_store') is-invalid @enderror" id="product_store" name="product_store" value="{{ old('product_store') }}">
                                    <label for="product_store">Product Store</label>
                                </div>
                                @error('product_store')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

-->

                        <!-- begin: Input Image -->
<!--
                        <div class="form-group row align-items-center">
                            <div class="col-md-12">
                                <div class="profile-img-edit">
                                    <div class="crm-profile-img-edit">
                                        <img class="crm-profile-pic rounded-circle avatar-100" id="image-preview" src="{{ asset('assets/images/product/default.webp') }}" alt="profile-pic">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="input-group mb-4 col-lg-6">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('product_image') is-invalid @enderror" id="image" name="product_image" accept="image/*" onchange="previewImage();">
                                    <label class="custom-file-label" for="product_image">Choose file</label>
                                </div>
                                @error('product_image')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
-->                        
                        <!-- end: Input Image -->








                        </div>
                        <!-- end: Input Data -->
                        <!--
                        <div class="mt-2">
                            <button type="submit" class="btn btn-primary mr-2">Save</button>
                            <a class="btn bg-danger" href="{{ route('products.index') }}">Cancel</a>
                        </div>
                        -->
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Page end  -->
</div>

<script>
    $('#buying_date').datepicker({
        uiLibrary: 'bootstrap4',
        format: 'yyyy-mm-dd'
        // https://gijgo.com/datetimepicker/configuration/format
    });
    $('#expire_date').datepicker({
        uiLibrary: 'bootstrap4',
        format: 'yyyy-mm-dd'
        // https://gijgo.com/datetimepicker/configuration/format
    });
</script>

@include('components.preview-img-form')
@endsection
