@extends('dashboard.body.main')

@section('container')

        <div class="col-lg-12">
            @if (session()->has('success'))
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Outstanding Payments for <i>{{ $Supplier->name }} (TZS {{ $header->Amount }})</i></h4>
                    <!--
                    <p class="mb-0">A supplier dashboard lets you easily gather and visualize supplier data from optimizing <br>
                        the supplier experience, ensuring supplier retention. </p>
                    -->
                </div>
                <div>
                    <a href="{{ route('payment.outgoing.suppliers') }}" class="btn add-list"><i class="fa-solid fa-plus mr-3"></i>Complete</a>
                    <!-- <a href="{{ route('order.index') }}" class="btn btn-danger add-list"><i class="fa-solid fa-trash mr-3"></i>Clear Search</a> -->
                </div>
            </div>
        </div>

        <table class="table">
            <tr>
                <td>PO Number</td>
                <td>Amount (TZS)</td>
                <td>Status</td>
                <td>Action</td>
            </tr>
        @foreach($outstandingPays as $outstandingPay)
            <tr>
                <td>{{$outstandingPay->ControlNum}}</td>
                <td>{{$outstandingPay->ItemTotal}}</td>
                <td>Status</td>
                <td>
                    <form method="POST" action="{{ route('payment.outgoing.pay',[$header->id,$outstandingPay->ControlNum,$outstandingPay->ItemTotal ]) }}">
                        @csrf
                        <button type="submit" class="btn">Pay</button>
                    </form>
                </td>
            </tr>
        @endforeach
        </table>


@endsection
