@extends('dashboard.body.main')

@section('container')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <form action="{{ route('categories.store') }}" method="POST">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Create Category</h4>
                        </div>
                        <div>
                                <button type="submit" class="btn  mr-2">Save</button>
                                <a class="btn " href="{{ route('categories.index') }}">Cancel</a>
                        </div>
                    </div>

                    <div class="card-body">

                        @csrf
                            <!-- begin: Input Data -->
                            <div class=" row align-items-center">
                                <div class="form-group col-md-12">
                                    <label for="name">Code <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" id="Code" name="Code"  required>
                                    @error('name')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-12">
                                    <label for="slug">Description <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('slug') is-invalid @enderror" id="Description" name="Description" required>
                                    @error('slug')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>

                            </div>
                            <!-- end: Input Data -->
                            <div class="mt-2">
                            </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- Page end  -->
</div>

<script>
    // Slug Generator
    const title = document.querySelector("#name");
    const slug = document.querySelector("#slug");
    title.addEventListener("keyup", function() {
        let preslug = title.value;
        preslug = preslug.replace(/ /g,"-");
        slug.value = preslug.toLowerCase();
    });
</script>

@include('components.preview-img-form')
@endsection
