@extends('dashboard.body.main')

@section('container')
<form method="POST" action="{{route('inventory.save',[$store->id,$product->id])}}">


<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            @if (session()->has('success'))
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert text-white bg-danger" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">{{ $store->name }} - {{ $product->product_code }}</h4>

                </div>
                <div>
                    <!--
                    <a href="{{ route('products.importView') }}" class="btn btn-success add-list">Import</a>
                    <a href="{{ route('products.exportData') }}" class="btn btn-warning add-list">Export</a>
                    -->
                    <!-- <a href="{{ route('products.create') }}" class="btn btn-primary add-list">Add Product</a> -->
                        @csrf
                        <button class="btn" type="submit">Save</button>

                </div>
            </div>
        </div>
    </div>





    <div class="form-group col-md-4">
        <div class="form-floating mb-3 ">
            <input type="text" class="form-control" id="quantity"  name="quantity" placeholder="Code" required/>
            <label for="address1">Available Quantity in {{ $unit->Code }} <span class="text-danger">*</span></label>
        </div>
        @error('address1')
            <div class="invalid-feedback">
                {{ $message }}
            </div>
        @enderror
    </div>
</div>

</form>

<div>
        @foreach($histories as $history)
            <div class="card">
                <div class="card-block">
                  <h6 class="card-title">{{ $history->remarks }}</h6>
                  <p class="card-text p-y-1">{{ $history->applydate }} {{ $history->quantity }}</p>
                </div>
            </div>
        @endforeach
</div>




@endsection
