@extends('dashboard.body.main')

@section('container')
<div class="container-fluid">
     <div class="row">
            <div class="col-lg-12">
                @if (session()->has('success'))
                    <div class="alert text-white bg-success" role="alert">
                        <div class="iq-alert-text">{{ session('success') }}</div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <i class="ri-close-line"></i>
                        </button>
                    </div>
                @endif
                <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                    <div>
                        <h4 class="mb-3">{{ ($id==1)?'Revenue':'Expenditure' }} List</h4>
                    </div>
                    <div>
                        <form method="POST" action="{{route('RevExp.Home',[$id])}}">
                            @csrf
                            <button type="submit" class="btn"> <i class="fa-solid fa-plus mr-3"></i>Add Account </button>
                        </form>
                        <!-- <a href="{{ route('order.index') }}" class="btn btn-danger add-list"><i class="fa-solid fa-trash mr-3"></i>Clear Search</a> -->
                    </div>
                </div>
            </div>
     </div>
    <div>
        <table class="table">
                @foreach($glaccounts as $glaccount)
                    <tr>
                        <td>{{ $glaccount->glcode }}</td>
                        <td>{{ $glaccount->code }}</td>
                        <td>{{ $glaccount->Description }}</td>
                        <td>
                            <form method="POST" action="{{route('RevExp.details',[$id,$glaccount->id])}}">
                                @csrf
                                <button class="btn"><i class="fa fa-plus" aria-hidden="true"></i></button>
                            </form>

                        </td>
                    </tr>
                @endforeach
        </table>
    </div>
@endsection
