@extends('dashboard.body.main')

@section('container')
<div class="col-12">

</div>

<div class="flex-auto flex flex-col" id="dashboard-content">
        <div class="px-4 row">
            <div class="col-4 mb-4">
                <h3 class="text-3xl text-primary font-bold">Purchases List Report</h3>
            </div>
            <div class="col-8">
                <form method="POST" action="{{route('repPurchases.index')}}">
                    @csrf
                    <ul class="list-inline">
                        <li  class="list-inline-item  col-4">
                            <div class="form-floating">
                                <input type="date" class="form-control" id="StartDate" name="StartDate" placeholder="Start Date" value="{{$ReportParam->Start_Date}}">
                                <label for="floatingPassword">Start Date</label>
                            </div>
                        </li>
                        <li  class="list-inline-item col-4">
                            <div class="form-floating">
                                <input type="date" class="form-control" id="EndDate" name="EndDate" placeholder="End Date" value="{{$ReportParam->End_Date}}">
                                <label for="floatingPassword">End Date</label>
                            </div>
                        </li>
                        <li  class="list-inline-item">
                            <button @click="loadReport()" class="rounded flex justify-between text-primary shadow py-1 items-center  px-2">
                                    <i class="las la-sync-alt text-xl"></i>
                                    <span class="pl-2">Load</span>
                            </button>
                        </li>
                        <li  class="list-inline-item">
                            <button @click="printSaleReport()" class="rounded flex justify-between text-primary shadow py-1 items-center  px-2">
                                <i class="las la-print text-xl"></i>
                                <span class="pl-2">Print</span>
                            </button>
                        </li>
                    </ul>
                </form>


            </div>
        </div>

        <div class="row">
            <div class="col-12">
            </div>
            <div id="report-section" class="px-4 info-div overflow-auto" style="height: 500px; width:100%;">


                <table class="table">

                    <tr>
                        <th>Name</th>
                        <th>Supplier</th>
                        <th style="text-align: right">Currency </th>
                        <th style="text-align: right">Amount</th>

                    </tr>
                @php $total = 0; @endphp
                @foreach($PurchasesOrders as $PurchasesOrder)
                    <tr>
                        <td>{{$PurchasesOrder->ApplyDate}}</td>
                        <td>{{$PurchasesOrder->Item}}</td>
                        <td>{{$PurchasesOrder->store}}</td>
                        <td>{{$PurchasesOrder->Code}}</td>
                        <td style="text-align: right">{{$PurchasesOrder->QtyReceived }}</td>
                    </tr>
                @endforeach

          
                </table>


            </div>
        </div>




</div>


@endsection

@section('specificpagescripts');
<script>
    loadReport();
</script>


@endsection
