@extends('dashboard.body.main')

@section('container')

<div class="flex-auto flex flex-col" id="dashboard-content">
        <div class="px-4 row">
                <div class="col-4 mb-4">
                    <h3 class="text-3xl text-primary font-bold">Product List Report</h3>
                </div>
                <div class="col-8">
                    <form method="POST" action="{{route('ProductList.Report')}}">
                        @csrf
                        <ul class="list-inline">
                            <li  class="list-inline-item  col-4">
                                <div class="form-floating">
                                    <input type="date" class="form-control" id="StartDate" name="StartDate" placeholder="Start Date" value="{{ $request->StartDate }}">
                                    <label for="floatingPassword">Start Date</label>
                                </div>
                            </li>
                            <li  class="list-inline-item col-4">
                                <div class="form-floating">
                                    <input type="date" class="form-control" id="EndDate" name="EndDate" placeholder="End Date" value="{{ $request->EndDate }}">
                                    <label for="floatingPassword">End Date</label>
                                </div>
                            </li>
                            <li  class="list-inline-item">
                                <button id="loadReport" name="loadReport" class="rounded flex justify-between text-primary shadow py-1 items-center  px-2">
                                        <i class="las la-sync-alt text-xl"></i>
                                        <span class="pl-2">Load</span>
                                </button>
                            </li>
                            <li  class="list-inline-item">
                                <a href="{{route('ProductList.pdf')}}" class="btn" target="_blank">
                                    <i class="las la-print text-xl"></i>
                                    <span class="pl-2">Print</span>
                                </a>
                            </li>
                        </ul>
                    </form>
                </div>
        </div>

        <div class="row">
            <div class="col-12">
            </div>
            <div id="report-section" class="px-4 info-div overflow-auto" style="height: 500px; width:100%;">
                <table class="table">

                    <tr>
                        <th>Product</th>
                        <th>BuyingUnit</th>
                        <th class="text-align: right;">Buying Price </th>
                        <th>Selling Unit</th>
                        <th class="text-align: right;">Selling Price</th>
                        <th class="text-align: right;">Qty PCS</th>
                        <th>Item Profit </th>
                        <th>Total Profit</th>
                    </tr>

                @foreach($products as $product)
                    <tr>
                        <td>{{$product->product_code}}</td>
                        <td>{{$product->BuyingUnit}}</td>
                        <td class="text-align: right;">{{$product->buying_price}}</td>
                        <td>{{$product->SellingUnit}}</td>
                        <td class="text-align: right;">{{$product->selling_price}}</td>
                        <td class="text-align: right;">{{$product->factor}}</td>
                        <td>{{number_format(($product->selling_price - ($product->buying_price/$product->factor)),2)}}</td>
                        <td>{{number_format((($product->selling_price * $product->factor) - $product->buying_price),2) }}</td>
                    </tr>
                @endforeach
                </table>
            </div>
        </div>




</div>


@endsection

@section('specificpagescripts');

@endsection
