<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('product_code');
            $table->string('product_name');
            $table->integer('category_id');
            $table->integer('supplier_id');
            $table->Integer('BuyingUnit');
            $table->Integer('SellingUnit');
            $table->decimal('factor',5,2);
            $table->integer('buying_price');
            $table->integer('selling_price');
            $table->string('barcode');
            $table->integer('tax_id');
            $table->integer('SalesStatus')->default(0);
            $table->integer('Cauntable')->default(0);
            $table->integer('option1')->default(0);
            $table->string('product_image')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
