<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    public const HOME = '/dashboard';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     */
    public function boot(): void
    {
        $this->configureRateLimiting();

        $this->routes(function () {
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api.php'));

            Route::middleware('web')
                ->group(base_path('routes/web.php'));


            Route::middleware('web')
                ->prefix('new')
                ->group(base_path('routes/new.php'));

            Route::middleware('web')
                ->prefix('Purchases')
                ->group(base_path('routes/Purchases.php'));

            Route::middleware('web')
                ->prefix('Sales')
                ->group(base_path('routes/Sales.php'));

            Route::middleware('web')
                ->prefix('Report')
                ->group(base_path('routes/reports.php'));

            Route::middleware('web')
                ->prefix('Payments')
                ->group(base_path('routes/payments.php'));
                
                

            Route::middleware('web')
                ->prefix('inventory')
                ->group(base_path('routes/Inventory.php'));                
                
  
            Route::middleware('web')
                ->prefix('revexp')
                ->group(base_path('routes/RevExp.php'));   
                

            Route::middleware('web')
                ->group(base_path('routes/storeprice.php'));                
                
                

        });
    }

    /**
     * Configure the rate limiters for the application.
     */
    protected function configureRateLimiting(): void
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });
    }
}
