<?php

namespace App\Providers;

use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;
use  App\Events\PO_Complete;
use  App\Events\receiveorderitem;
use  App\Events\SalesComplete;
use  App\Events\stockadjustment;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event to listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        PO_Complete::class =>[
         
            '\App\Listeners\updatePO',
            '\App\Listeners\DelOrderDefComplete',
            '\App\Listeners\POOutstandingPay',
            '\App\Listeners\updatestorestock',
        ],

        receiveorderitem::class=>[
            'App\Listeners\saveItemReceived',
            'App\Listeners\storestockupdate',
            'App\Listeners\updateStock',
        ],
        SalesComplete::class=>[
            'App\Listeners\SalesComp',
            'App\Listeners\SalesUpdateStock',
            'App\Listeners\SalesQtyUpdate',
        ],
        stockadjustment::class=>[
            'App\Listeners\saveStockAdjustment',
            'App\Listeners\adjUpdateStockLevel',
            'App\Listeners\adjUpdateStockLevelstore',
        ],        
    ];

/*
            'App\Listeners\SalesComp',
            'App\Listeners\SalesUpdateStock',
*/



    /**
     * Register any events for your application.
     */
    public function boot(): void
    {
        //
    }

    /**
     * Determine if events and listeners should be automatically discovered.
     */
    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}
