<?php

namespace App\Http\Controllers\Sales;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


use Illuminate\Support\Facades\Validator; // Correct facade

use App\Models\ItemSalesTemp;
use App\Models\paymentMode;
use App\Models\SalesPaymode;



use App\Events\SalesComplete;




use DB;




class newSalesController extends Controller
{
    public function index(){
        return view('sales.new.index');
    }




    public function savelineItems(Request $request){
        //$ItemSalesTemp = new ItemSalesTemp();
        \Log::info('Raw JSON received:', [$request->getContent()]);
    \Log::info('All request data:', $request->all());

        $validator = Validator::make($request->all(), [
            'control_num' => 'required|string',
            'customer_id' => 'required|integer',
            'payment_mode' => 'required|integer',
            //'gross_total' => 'required|numeric|min:0',
            //'tax_total' => 'required|numeric|min:0',
            //'discount' => 'required|numeric|min:0',
            //'grand_total' => 'required|numeric|min:0',
            'sales_items' => 'required|array',
            'sales_items.items' => 'required|array|min:1',
            'sales_items.items.*.item_name' => 'required|string|max:255',
            'sales_items.items.*.price' => 'required|numeric|min:0.01',
            'sales_items.items.*.quantity' => 'required|integer|min:1',
            'sales_items.items.*.taxctrlnum' => 'required|numeric|min:0.01',
            'sales_items.items.*.itemctrlnum' => 'required|numeric|min:0.01',
            /*'sales_items.items.*.total' => 'required|numeric|min:0.01',
            'sales_items.items.*.tax_rate' => 'required|numeric|min:0',
            'sales_items.items.*.tax_amount' => 'required|numeric|min:0',*/
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ], 422);
        }

        DB::beginTransaction();
        try {
            $salesItems = $request->sales_items;
            $grandTotal = collect($salesItems)->sum('total');


            SalesPaymode::create([
                'SalesCtrlNum'=>$request->control_num, 'PayModeCtrlNum'=>$request->payment_mode,
            ]);
            // Check stock availability if product IDs are provided
            // Check stock availability if product IDs are provided
            foreach ($salesItems['items'] as $item) { // Fixed array access
                $ItemSalesTemp = new ItemSalesTemp();

                $ItemSalesTemp->OrderCtrlNum = $request->control_num;
                $ItemSalesTemp->itemctrlnum = $item['itemctrlnum'] ?? null; // Fixed array access and added null coalescing
                $ItemSalesTemp->quantity = $item['quantity']; // Fixed array access
                $ItemSalesTemp->price = $item['price']; // Fixed array access
                $ItemSalesTemp->UserId = auth()->id(); // Simplified

                $ItemSalesTemp->save();
            }



            event(new SalesComplete($request->control_num));







/*

                if (!empty($item['product_id'])) {
                    $product = Product::find($item['product_id']);
                    if ($product && $product->stock_quantity < $item['quantity']) {
                        throw new \Exception("Insufficient stock for {$item['item_name']}. Available: {$product->stock_quantity}");
                    }
                }
            */
          //  }

            // Create sale record
            /*
            $sale = Sale::create([
                'invoice_number' => $this->generateInvoiceNumber(),
                'grand_total' => $grandTotal,
                'sale_date' => now(),
                'user_id' => auth()->id(),
                'customer_name' => $request->customer_name,
                'payment_method' => $request->payment_method,
                'status' => 'completed',
                'notes' => $request->notes,
            ]);

            // Create sale items and update stock
            foreach ($salesData as $item) {
                $saleItem = SaleItem::create([
                    'sale_id' => $sale->id,
                    'product_id' => $item['product_id'] ?? null,
                    'product_name' => $item['item_name'],
                    'unit_price' => $item['price'],
                    'quantity' => $item['quantity'],
                    'total_price' => $item['total'],
                ]);

                // Update product stock if product ID exists
                if (!empty($item['product_id'])) {
                    $product = Product::find($item['product_id']);
                    if ($product) {
                        $product->decrement('stock_quantity', $item['quantity']);
                    }
                }
            }
*/






            DB::commit();

            // You can generate PDF invoice here if needed
            // $this->generateInvoice($sale->id);

            return response()->json([
                'success' => true,
                'message' => 'Sale recorded successfully',
               /*

                'data' => [
                    'sale_id' => $sale->id,
                    'invoice_number' => $sale->invoice_number,
                    'grand_total' => $grandTotal,
                    'sale_date' => $sale->sale_date->format('d/m/Y H:i:s')
                ]
                */
            ]);

        } catch (\Exception $e) {
            DB::rollBack();
            \Log::error('Sale creation error: ' . $e->getMessage());

            return response()->json([
                'success' => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }
}
