<?php

namespace App\Http\Controllers\Sales;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Product;

use App\Http\Controllers\OutonumController;

use App\Models\ItemSalesTemp;

use App\Models\Customer;
use App\Models\paymentMode;


use App\Events\SalesComplete;


use DB;
use auth;
use Barryvdh\DomPDF\Facade\Pdf;


class SalesController extends Controller
{
    public function index(){
        $OutonumController = new OutonumController();
        


        $Customers = Customer::all();
        $paymentModes = paymentMode::all();

      
        
        if (auth()->user()->store <= 0){
             return view('sales.error');
        }
        return view('sales.index',compact('Customers','paymentModes'))->with('ControlNum',$OutonumController->ControlNumber('CON02'));
    }

    public function getItemDetail($ItemCtrlNum){
        $Product = Product::SELECT('products.id',
                                    'products.tax_id',
                                    'products.product_code',
                                    'products.product_name',
                                    'products.category_id',
                                    'products.supplier_id',
                                    'products.BuyingUnit',
                                    'products.SellingUnit',
                                    'products.factor',
                                    'products.buying_price',
                                    'products.selling_price',
                                    'taxes.name')
                    ->JOIN('taxes','products.tax_id','taxes.id')
                    ->WHERE('barcode',$ItemCtrlNum)->first();
        $storeprice = DB::Table('storeprices')->SELECT('*')->WHERE('productid',$Product->id)->WHERE('storeid',auth()->user()->store)->first();
        $Product->selling_price = is_null($storeprice) ? $Product->selling_price:$storeprice->price;                    
        return response()->json($Product);
    }



    public function getItemByDescriptio($ItemName){
        //$Products = DB::SELECT("SELECT * FROM products WHERE product_name like '%?%'",[$ItemName]);
        $Products = Product::where('product_name', 'like', '%' .$ItemName .'%' )->get();
        return response()->json($Products);
    }

    public function SaveSalesItem(Request $request,String $orderCtrlNum){
        $ItemSalesTemp = new ItemSalesTemp();

        $ItemSalesTemp->OrderCtrlNum = $orderCtrlNum;
        $ItemSalesTemp->itemctrlnum = $request->itemctrlnum;
        $ItemSalesTemp->quantity = $request->quantity;
        $ItemSalesTemp->price = $request->price;
        $ItemSalesTemp->UserId = auth()->user()->id;

        $ItemSalesTemp->save();
        //return redirect()->route('sales.index');
    }

    public function ItemBoughtList(String $SalesCtrlNum){
        //$ItemSalesTemp = ItemSalesTemp::SELECT('*')->WHERE('OrderCtrlNum',$SalesCtrlNum);
        $ItemSalesTemp = DB::SELECT("SELECT a.id, a.OrderCtrlNum,
                                            a.itemctrlnum,
                                            a.quantity,
                                            a.price,
                                            b.product_name,
                                            a.quantity * a.price as 'ItemTotal'
                                    FROM    item_sales_temps a,
                                            products b
                                    WHERE   a.itemctrlnum = b.id
                                    AND     a.OrderCtrlNum = ?",[$SalesCtrlNum]);//ItemSalesTemp::SELECT('*')->WHERE('OrderCtrlNum',$SalesCtrlNum);
        return response()->json($ItemSalesTemp);
    }

    public function SalesComplete(Request $request,String $ControlNum){
            event(new SalesComplete($ControlNum));
            return redirect()->route('sales.print',$ControlNum);
    }

    public function printsales(String $ControlNum){

            $soldItems = DB::SELECT("select a.itemctrlnum,
                                        b.product_code,
                                        b.product_code,
                                        a.taxCtrlNum,
                                        a.taxAmount,
                                        a.quantity,
                                        a.price
                                from    sales_item_dets a,
                                        products b
                                WHERE   a.itemctrlnum = b.id
                                AND     a.OrderCtrlNum = ?",[$ControlNum]);
            return view('sales.print',compact('ControlNum','soldItems'));
    }


    public function receipt(String $ControlNum){
              $data = [
                    [
                        'quantity' => 1,
                        'description' => '1 Year Subscription',
                        'price' => '129.00'
                    ]
                ];
             $pdf = Pdf::loadView('sales.receipt', ['data' => $data]);
            return $pdf->stream();

    }

    public function deleteItem(String $ControlNum,String $ItemCtrlNum){
        $ItemSalesTemp = DB::DELETE("DELETE FROM item_sales_temps WHERE OrderCtrlNum = ? AND itemctrlnum = ? ",[$ControlNum,$ItemCtrlNum]);

        $ItemSalesTemp = ItemSalesTemp::WHERE('OrderCtrlNum','=',$ControlNum)->WHERE('itemctrlnum','=',$ItemCtrlNum)->delete();

// DELETE FROM item_sales_temps WHERE OrderCtrlNum = 'PI00022775' AND itemctrlnum = '33024' ",[$ControlNum,$ItemCtrlNum]

        //$ItemSalesTemp->delete();
        $data = [
            'success' => true,
            'message' => 'Data retrieved successfully',
            'data' => ['id' => $ControlNum, 'name' => $ItemSalesTemp]
        ];

        return response()->json($data);


    }


}
