<?php

namespace App\Http\Controllers\Purchases;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\modrequisation;
use App\Models\requisationArc;
use App\Models\Supplier;
use App\Models\Product;

use Auth;
use DB;

class Requisation extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $requisations = DB::Table('modrequisations')
                        ->SELECT('modrequisations.id','users.name','products.product_name','modrequisations.Quantity','suppliers.name as SupplierName')
                        ->join('products', 'products.id', '=', 'modrequisations.ProductId')
                        ->join('users','users.id','modrequisations.UserId')
                        ->join('suppliers','suppliers.id','modrequisations.supplierId')->paginate(5);
        return view('purchase.requisation.index')->with('requisations',$requisations);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {

        $Suppliers = Supplier::all();
        $Products = Product::all();
        return view('purchase.requisation.create')->with('Suppliers',$Suppliers)
                                                  ->with('Products',$Products);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $modrequisation = new modrequisation();
        //dd($request->leadtime);
        //modrequisation::create([$request->product,$request->supplier,$request->leadtime,Auth::user()->id,$request->quantity]);

        $modrequisation->ProductId = $request->product;
        $modrequisation->supplierId =  $request->supplier;
        //$modrequisation->leadtime =  $request->leadtime;
        $modrequisation->UserId =  Auth::user()->id;
        $modrequisation->Quantity = $request->quantity;

        $modrequisation->save();
        return redirect()->route('requisation.index');

    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $modrequisation = modrequisation::findorfail($id);
        $requisationArc = new requisationArc();



        $requisationArc->ProductId = $modrequisation->ProductId;
        $requisationArc->supplierId = $modrequisation->supplierId;
        $requisationArc->UserId = $modrequisation->UserId;
        $requisationArc->Quantity = $modrequisation->Quantity;
        //$requisationArc->Status = 0

        $requisationArc->save();

        $modrequisation->delete();
        return redirect()->route('requisation.index');
    }
}
